////////////////////////////////////////////////////////////////////////////
//
// VAf[^\.
// for SG12864A 128x64dot LCD
//
// by rubidesu 2016
// http://www.gatelink.co.jp/hw/
//
////////////////////////////////////////////////////////////////////////////

#include <16f877a.h>
#include "picdef.h"
#include "glcd_font.h"

#fuses hs,nowdt,noprotect,put,nobrownout,nolvp
#use delay(clock=20000000)

#define LCD_D	PORTD_BIT
#define LCD_RES	PORTC_BIT.bit4
#define LCD_CS1	PORTB_BIT.bit0
#define LCD_CS2	PORTC_BIT.bit5
#define LCD_E	PORTB_BIT.bit1
#define LCD_RW	PORTB_BIT.bit2
#define LCD_DI	PORTB_BIT.bit3

#define LCD_CMD	0
#define LCD_DAT	1

struct BITSWAP sBitSwap;

#define RCV_MAX		64			//Mobt@TCY.
BYTE rcv_stack[RCV_MAX];		//Mobt@.
BYTE rcv_read = 0;				//Mobt@̃[h|C^.
BYTE rcv_write = 0;				//Mobt@̃Cg|C^.
BYTE rcv_buff;					//Mobt@󂯓npϐ.

//VAʐM֌W̃WX^.
#byte SPBRG = 0x99
#byte TXSTA = 0x98
#byte RCSTA = 0x18
#byte RCREG = 0x1a
#bit  RCIF  = 0x0c.5

//{[[g.
typedef struct tagBAUD_INFO{
	BYTE bBaudStr[12];
	BYTE bTXSTA;
	BYTE bRCSTA;
	BYTE bSPBRG;
} BAUD_INFO;

const BAUD_INFO BaudInfo[8] = {
	{"\r1200bps\r",	34, 144, 255 },
	{"\r2400bps\r",	34, 144, 129 },
	{"\r4800bps\r",	34, 144, 64	 },
	{"\r9600bps\r",	38, 144, 129 },
	{"\r19200bps\r",	38, 144, 64	 },
	{"\r38400bps\r",	38, 144, 32	 },
	{"\r57600bps\r",	38, 144, 21	 },
	{"\r115200bps\r",	38, 144, 10	 }
};

//DIPSW̏Ԃۑ.
BYTE bLastSW = 0xff;

////////////////////////////////////////////////////////////////////////////
void lcd_Write(BIT cs, BYTE code, BIT DIflag)
{
	LCD_CS1 = !cs;
	LCD_CS2 = cs;

	LCD_DI = DIflag;
	if(DIflag == LCD_DAT){
		LCD_D = code;
	}
	else{
		sBitSwap = code;
		LCD_D.bit0 = sBitSwap.bit7;
		LCD_D.bit1 = sBitSwap.bit6;
		LCD_D.bit2 = sBitSwap.bit5;
		LCD_D.bit3 = sBitSwap.bit4;
		LCD_D.bit4 = sBitSwap.bit3;
		LCD_D.bit5 = sBitSwap.bit2;
		LCD_D.bit6 = sBitSwap.bit1;
		LCD_D.bit7 = sBitSwap.bit0;
	}
	delay_us(1);
	LCD_E = 1;
	delay_us(1);
	LCD_E = 0;
	delay_us(5);
}

////////////////////////////////////////////////////////////////////////////
void lcd_Clear(BYTE data)
{
	BYTE page;
	BYTE colum;

	for(page = 0; page < 8; page++){
		lcd_Write(0, 0xB8 + page, LCD_CMD);			// page set
		lcd_Write(0, 0x40, LCD_CMD);				// colum reset
		lcd_Write(1, 0xB8 + page, LCD_CMD);			// page set 
		lcd_Write(1, 0x40, LCD_CMD);				// colum reset
		for(colum = 0; colum < 64; colum++){			// repeat 64 colum
			lcd_Write(0, data, LCD_DAT);			// fill data
			lcd_Write(1, data, LCD_DAT);			// fill data
		}
	}
	lcd_Write(0, 0xC0, LCD_CMD);					// reset start line
	lcd_Write(1, 0xC0, LCD_CMD);
}

////////////////////////////////////////////////////////////////////////////
void lcd_Init(void)
{
	delay_ms(10);
	lcd_Write(0, 0x3F, LCD_CMD);					// Display on
	lcd_Write(1, 0x3F, LCD_CMD);					// Display on
	lcd_Clear(0x00);
}

////////////////////////////////////////////////////////////////////////////
void lcd_OutChar(BYTE x, BYTE y, BYTE dat)
{
	BYTE i;
	BYTE fonty;
	BYTE fontn;

	x = (x * (FONT_WIDTH+1)) + 4;	//+4̓ItZbg̃hbg.

	fonty = dat % 32;	//32PʂŃtHgf[^𕪊Ă.
	fontn = dat / 32;	//32PʂŃtHgf[^𕪊Ă.

	//0-63 64-127
	if(x >= 64){
		lcd_Write(1, 0xB8+y, LCD_CMD);			// page set
		lcd_Write(1, 0x40+(x-64), LCD_CMD);		// colum reset

		switch(fontn){
		case 0:
			for(i = 0; i < FONT_WIDTH; i++){
				lcd_Write(1, font_tbl0[fonty][i], LCD_DAT);
			}
			break;
		case 1:
			for(i = 0; i < FONT_WIDTH; i++){
				lcd_Write(1, font_tbl1[fonty][i], LCD_DAT);
			}
			break;
		case 2:
			for(i = 0; i < FONT_WIDTH; i++){
				lcd_Write(1, font_tbl2[fonty][i], LCD_DAT);
			}
			break;
		case 3:
			for(i = 0; i < FONT_WIDTH; i++){
				lcd_Write(1, font_tbl3[fonty][i], LCD_DAT);
			}
		}
	}
	else{
		lcd_Write(0, 0xB8+y, LCD_CMD);			// page set
		lcd_Write(0, 0x40+x, LCD_CMD);			// colum reset

		switch(fontn){
		case 0:
			for(i = 0; i < FONT_WIDTH; i++){
				lcd_Write(0, font_tbl0[fonty][i], LCD_DAT);
			}
			break;
		case 1:
			for(i = 0; i < FONT_WIDTH; i++){
				lcd_Write(0, font_tbl1[fonty][i], LCD_DAT);
			}
			break;
		case 2:
			for(i = 0; i < FONT_WIDTH; i++){
				lcd_Write(0, font_tbl2[fonty][i], LCD_DAT);
			}
			break;
		case 3:
			for(i = 0; i < FONT_WIDTH; i++){
				lcd_Write(0, font_tbl3[fonty][i], LCD_DAT);
			}
		}
	}
}

////////////////////////////////////////////////////////////////////////////
void push_buff(BYTE bDat)
{
	rcv_stack[rcv_write] = bDat;

	rcv_write++;
	rcv_write = rcv_write % RCV_MAX;
}

////////////////////////////////////////////////////////////////////////////
BYTE get_sw()
{
	return (~PORTB & 0x70) >> 4;
}

////////////////////////////////////////////////////////////////////////////
void set_baud()
{
	BYTE bIndex;

	bIndex = get_sw();

	TXSTA = BaudInfo[bIndex].bTXSTA;
	RCSTA = BaudInfo[bIndex].bRCSTA;
	SPBRG = BaudInfo[bIndex].bSPBRG;
	RCIF = 0;

	push_buff(BaudInfo[bIndex].bBaudStr);
}

////////////////////////////////////////////////////////////////////////////
#INT_RB
void int_rb_isr(void)
{
	if(bLastSW != get_sw()){
		set_baud();
	}
	bLastSW = get_sw();
	delay_ms(100);
}

////////////////////////////////////////////////////////////////////////////
#INT_RDA
void int_rda_isr(void)
{
	if(RCIF == 1){
		rcv_stack[rcv_write] = RCREG;

		rcv_write++;
		rcv_write = rcv_write % RCV_MAX;

		RCIF = 0;
	}
}

////////////////////////////////////////////////////////////////////////////
BYTE getc_buff(void)
{
	if(rcv_read != rcv_write){
		rcv_buff = rcv_stack[rcv_read];
		rcv_read++;
		rcv_read = rcv_read % RCV_MAX;
		return 1;
	}
	else{
		return 0;
	}
}

////////////////////////////////////////////////////////////////////////////
// C.
//
// IN:
//
// OUT:
//
// RETURN:
//
////////////////////////////////////////////////////////////////////////////
main()
{
	BYTE x = 0;
	BYTE y = 7;
	BYTE bTemp;
	BYTE i;

	setup_adc(NO_ANALOGS);          //Not Used
	set_tris_a(0b00000000);         //PORT A
	set_tris_b(0b01110000);         //PORT B
	set_tris_c(0b10000000);         //PORT C
	set_tris_d(0b00000000);         //PORT D
	set_tris_e(0b00000000);         //PORT E

	set_baud();

	enable_interrupts(INT_RDA);
	enable_interrupts(INT_RB);
	enable_interrupts(GLOBAL);

	delay_ms(10);

	//LCD̃|[gl.
	LCD_RES = HIGH;
	LCD_RW = LOW;

	lcd_Init();

	//LCDTCh̏.
	for(i = 0; i < 8; i++){
		lcd_Write(1, 0xB8+i, LCD_CMD);		// page set
		lcd_Write(1, 0x40+61, LCD_CMD);		// colum reset
		lcd_Write(1, 0b00000001, LCD_DAT);	// fill data
		lcd_Write(1, 0b11111111, LCD_DAT);	// fill data
		lcd_Write(1, 0b00000000, LCD_DAT);	// fill data

		lcd_Write(0, 0xB8+i, LCD_CMD);		// page set
		lcd_Write(0, 0x40+0, LCD_CMD);		// colum reset
		lcd_Write(0, 0b11111111, LCD_DAT);	// fill data
		lcd_Write(0, 0b00000001, LCD_DAT);	// fill data
		lcd_Write(0, 0b00000000, LCD_DAT);	// fill data
	}

	//ʒuɃJ[\\.
	lcd_OutChar(x, y, 0x5f);

	while(1){
		//Mf[^܂ő҂.
		while(getc_buff() == 0){
			;
		}

		switch(rcv_buff){
		case 0x0a:
			break;
		case 0x0d:
			//s}[Nt.
			lcd_OutChar(x, y, 0x7f);

			//sXV.
			y++;
			y %= 8;

			//̍sXy[XœhԂ.
			for(i = 0; i < 20; i++){
				lcd_OutChar(i, y, ' ');
			}

			//XN[.
			bTemp = (y + 1) % 8;
			lcd_Write(0, 0xC0 + (bTemp * 8),LCD_CMD);
			lcd_Write(1, 0xC0 + (bTemp * 8),LCD_CMD);

			//sɈʒu߂.
			x = 0;

			//̈ʒuɃJ[\\.
			lcd_OutChar(x, y, 0x5f);

			break;
		default:
			lcd_OutChar(x, y, rcv_buff);
			x++;
			if(x >= 20){
				//sXV.
				y++;
				y %= 8;

				//̍sXy[XœhԂ.
				for(i = 0; i < 20; i++){
					lcd_OutChar(i, y, ' ');
				}

				//XN[.
				bTemp = (y + 1) % 8;
				lcd_Write(0, 0xC0 + (bTemp * 8),LCD_CMD);
				lcd_Write(1, 0xC0 + (bTemp * 8),LCD_CMD);

				//sɈʒu߂.
				x = 0;
			}

			//̈ʒuɃJ[\\.
			lcd_OutChar(x, y, 0x5f);

			break;
		}
	}
}

