////////////////////////////////////////////////////////////////////////////
//
// C/x/xv.
//
//   Copyright by rubidesu 2013
//   http://www.gatelink.co.jp/hw/
//
//   Version 1.00 2013.10.07
//
////////////////////////////////////////////////////////////////////////////

#include <16f688.h>

#include "picdef.h"

#define _SERIAL_DEBUG_
//#undef _SERIAL_DEBUG_

#fuses INTRC_IO, NOWDT, PUT, NOPROTECT, NOBROWNOUT, NOMCLR
#use I2C(master, sda=PIN_C1, scl=PIN_C0)

#ifdef _SERIAL_DEBUG_
	#use delay(clock=2000000)
	#use RS232(BAUD=9600, XMIT=PIN_A2, INVERT)
#else //_SERIAL_DEBUG_
	#use delay(clock=2000000)
#endif //_SERIAL_DEBUG_

#define PUSH_SW1		PORTC.bit4	//MODE.
#define PUSH_SW2		PORTA.bit5	//SET.
#define PUSH_SW3		PORTC.bit5	//UP.
#define PUSH_SW4		PORTA.bit4	//DOWN.

#define KEY_REP_START	50		//L[s[gn܂Ԋu(*10msec).
#define KEY_REP_TIME	20		//L[s[g̊Ԋu(msec).

#define SW_NONE			0		//XCb`ĂȂ.
#define SW_SHORT		1		//Z.
#define SW_REPEAT		2		//L[s[g.
#define SW_LONG			3		//.

#define IIC_WRITE		0x00	//I2CCgtO.
#define IIC_READ		0x01	//I2C[htO.

#define RS_DATA			0x40	//LCDf[^.
#define RS_CMND			0x00	//LCDR}h.

#define ADDR_LCDr		0x7c	//LCD̃AhX.
#define ADDR_PRESS		0xb8	//CZT̃AhX.

#define ADDR_EEP_ALT	0		//xϊ̌WlۑEEPROMAhX.
#define PRESS_ALT_MAX	150		//xϊ̌Wl̍ő.
#define PRESS_ALT_MIN	50		//xϊ̌Wl̍ŏ.
#define PRESS_ALT_DEF	90		//xϊ̌Wl̏l.
BYTE bPressAlt;					//xϊ̌Wl.

signed long wRelativeAlt = 0;	//΍x.
signed long wAbsoluteAlt = 100;	//΍x.

WORD wRelativePress = 10132;	//΍x̋Cl.
WORD wAbsolutePress = 10132;	//΍x̋Cl.

#define MAX_SAMPLE	10			//ωobt@̃TCY.
BYTE iSampleNum = 0;			//ωobt@̃|C^.
DWORD dwSample[MAX_SAMPLE];		//ωobt@.

const BYTE bHexTable[16] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

BYTE bitPrintMode = 1;			//0:x\ 1:ڍו\.
BYTE bitSelector = 0;			//0:RelativeAltitude 1:AbsoluteAltitude.

////////////////////////////////////////////////////////////////////////////
void i2c_lcd_write(BYTE rs, BYTE dat)
{
	i2c_start();
	i2c_write(ADDR_LCDr | IIC_WRITE);	//address
	i2c_write(0x80 | rs);
	i2c_write(dat);
	i2c_stop();
}

////////////////////////////////////////////////////////////////////////////
void i2c_lcd_clear(void)
{
	i2c_lcd_write(RS_CMND, 0x01);
	delay_ms(2);
}

////////////////////////////////////////////////////////////////////////////
void i2c_lcd_putch(char c)
{
	i2c_lcd_write(RS_DATA, c);
}

////////////////////////////////////////////////////////////////////////////
void i2c_lcd_goto(BYTE pos)
{
	i2c_lcd_write(RS_CMND, 0x80+pos);
}

////////////////////////////////////////////////////////////////////////////
void i2c_lcd_init(void)
{
	i2c_lcd_write(RS_CMND, 0b00111000);	//0x38 function set.
	i2c_lcd_write(RS_CMND, 0b00111001);	//0x39 function set.
	i2c_lcd_write(RS_CMND, 0b00010100);	//0x14 internal osc frequency.
	i2c_lcd_write(RS_CMND, 0b01110000);	//0x70 contrast set.
	i2c_lcd_write(RS_CMND, 0b01010110);	//0x56 power/icon/contrast control.
	i2c_lcd_write(RS_CMND, 0b01101100);	//0x6C follower control.
	delay_ms(210);
	i2c_lcd_write(RS_CMND, 0b00111000);	//0x38 function set.
	i2c_lcd_write(RS_CMND, 0b00001100);	//0x0C display on/off control.
	i2c_lcd_write(RS_CMND, 0b00000001);	//0x01 clear display.
	delay_ms(2);
}

////////////////////////////////////////////////////////////////////////////
BYTE reg_read(BYTE addr)
{
	BYTE rcv = 0;

	i2c_start();
	i2c_write(ADDR_PRESS | IIC_WRITE);
	i2c_write(addr);
	i2c_start();
	i2c_write(ADDR_PRESS | IIC_READ);
	rcv = i2c_read(0);
	i2c_stop();

	return rcv;
}

////////////////////////////////////////////////////////////////////////////
void read_press_data(void)
{
	i2c_start();
	i2c_write(ADDR_PRESS | IIC_WRITE);
	i2c_write(0x28 | 0x80);
	i2c_start();
	i2c_write(ADDR_PRESS | IIC_READ);
	DWORD_CNV.DW2BADDR.a1 = i2c_read();
	DWORD_CNV.DW2BADDR.a2 = i2c_read();
	DWORD_CNV.DW2BADDR.a3 = i2c_read();
	DWORD_CNV.DW2BADDR.a4 = 0;
	WORD_CNV.W2BADDR.a1 = i2c_read();
	WORD_CNV.W2BADDR.a2 = i2c_read(0);
	i2c_stop();
}

////////////////////////////////////////////////////////////////////////////
void reg_write(BYTE addr, BYTE dat)
{
	i2c_start();
	i2c_write(ADDR_PRESS | IIC_WRITE);
	i2c_write(addr);
	i2c_write(dat);
	i2c_stop();
}

////////////////////////////////////////////////////////////////////////////
void PressOneShotStart(void)
{
	reg_write(0x20, 0x00);		//One shot.
	delay_ms(10);

	reg_write(0x10, 0x7a);		//One shot.

	reg_write(0x20, 0x84);		//One shot.
	delay_ms(10);

		read_press_data();	//Ôߋǂ pending.

	reg_write(0x21, 0x01);		//One shot.
}

////////////////////////////////////////////////////////////////////////////
#ifdef _SERIAL_DEBUG_
VOID put_hex(BYTE bDat)
{
	putc(bHexTable[bDat >> 4]);
	putc(bHexTable[bDat & 0x0f]);
}
#endif //_SERIAL_DEBUG_

/////////////////////////////////////////////////////////////////////////////////////////////////////
void AddSampleData(DWORD dwData)
{
	dwSample[iSampleNum] = dwData;

	iSampleNum++;
	iSampleNum %= MAX_SAMPLE;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
float GetSampleData(void)
{
	//float dblPress;
	float dblAvr = 0.0;
	BYTE iCount = 0;
	BYTE i;

	for(i = 0; i < MAX_SAMPLE; i++){
		if(dwSample[i] != 0){
			dblAvr += ((float)dwSample[i] / 4096.0);
			iCount++;
		}
	}
	if(iCount != 0){
		dblAvr /= (float)iCount;
	}

	return dblAvr;
}

////////////////////////////////////////////////////////////////////////////
void calc_time(void)
{
	//BYTE i;
	//DWORD dwPress;
	//WORD wTemp;
	float dblPress;
	float dblTemp;
	signed long wNowAlt;

	//////////////////////////////////////////////////
	//CZT̒lPC֑M.

#ifdef _SERIAL_DEBUG_
	put_hex(DWORD_CNV.DW2BADDR.a3);
	put_hex(DWORD_CNV.DW2BADDR.a2);
	put_hex(DWORD_CNV.DW2BADDR.a1);
	putc(' ');
	put_hex(WORD_CNV.W2BADDR.a2);
	put_hex(WORD_CNV.W2BADDR.a1);
	putc('\r'); putc('\n');
#endif //_SERIAL_DEBUG_

	//////////////////////////////////////////////////
	//CvZ.

	AddSampleData(DWORD_CNV.dwaddr);
	dblPress = GetSampleData();

	//////////////////////////////////////////////////
	//xvZ.

	dblTemp = (float)((signed long)WORD_CNV.waddr);
	dblTemp = dblTemp / 480.0;
	dblTemp = dblTemp + 42.5;

	//////////////////////////////////////////////////

	wRelativeAlt = (signed long)((((float)wRelativePress / 10.0) - dblPress) * ((float)bPressAlt / 10.0));
	wNowAlt = wAbsoluteAlt + (signed long)((((float)wAbsolutePress / 10.0) - dblPress) * ((float)bPressAlt / 10.0));

	//////////////////////////////////////////////////
	if(bitPrintMode == 1){
		i2c_lcd_goto(0x00);
		printf(i2c_lcd_putch, "P%07.2f", dblPress);

		//////////////////////////////////////////////////

		i2c_lcd_goto(0x40);
		printf(i2c_lcd_putch, "T%06.2fc", dblTemp);
	}
	else{
		i2c_lcd_goto(0x00);
		if(wRelativeAlt < 0){	//kuniku no saku.
			printf(i2c_lcd_putch, "%cR%4ldm", bitSelector == 0 ? 0x7e : ' ', wRelativeAlt);
		}
		else{
			printf(i2c_lcd_putch, "%cR%5ldm", bitSelector == 0 ? 0x7e : ' ', wRelativeAlt);
		}

		i2c_lcd_goto(0x40);
		if(wNowAlt < 0){	//kuniku no saku.
			printf(i2c_lcd_putch, "%cA%4ldm", bitSelector == 1 ? 0x7e : ' ', wNowAlt);
		}
		else{
			printf(i2c_lcd_putch, "%cA%5ldm", bitSelector == 1 ? 0x7e : ' ', wNowAlt);
		}
	}
}

////////////////////////////////////////////////////////////////////////////
BYTE get_sw1()
{
	//BIT sw_state = LOW;

	if(PUSH_SW1 == LOW){		//DOWN
		delay_ms(10);
		if(PUSH_SW1 == LOW){
			for(;;){
				if(PUSH_SW1 == HIGH){
					break;
				}
			}
			return HIGH;
		}
	}

	return LOW;
}

////////////////////////////////////////////////////////////////////////////
BYTE get_sw2()
{
	//BYTE sw_state = SW_NONE;
	BYTE bCnt = 0;

	if(PUSH_SW2 == LOW){		//DOWN
		delay_ms(10);
		for(bCnt = 0; bCnt < 200; bCnt++){
			if(PUSH_SW2 == HIGH){
				return SW_SHORT;
			}
			delay_ms(10);
		}
		while(1){
			if(PUSH_SW2 == HIGH){
				break;
			}
		}
		return SW_LONG;
	}

	return SW_NONE;
}

////////////////////////////////////////////////////////////////////////////
BYTE get_sw3()
{
	//BIT sw_state = LOW;

	if(PUSH_SW3 == LOW){		//DOWN
		delay_ms(10);
		if(PUSH_SW3 == LOW){
			for(;;){
				if(PUSH_SW3 == HIGH){
					break;
				}
			}
			return HIGH;
		}
	}

	return LOW;
}

////////////////////////////////////////////////////////////////////////////
BIT get_sw4()
{
	//BIT sw_state = LOW;

	if(PUSH_SW4 == LOW){		//DOWN
		delay_ms(10);
		if(PUSH_SW4 == LOW){
			for(;;){
				if(PUSH_SW4 == HIGH){
					break;
				}
			}
			return HIGH;
		}
	}

	return LOW;
}

////////////////////////////////////////////////////////////////////////////
BYTE get_sw3_rep(BYTE bRepFlg)
{
	//BYTE sw_state = SW_NONE;
	BYTE wCnt = 0;

	if(PUSH_SW3 == LOW){		//DOWN
		delay_ms(10);
		if(PUSH_SW3 == LOW){		//DOWN
			if(bRepFlg == SW_REPEAT){
				delay_ms(KEY_REP_TIME);
				return SW_REPEAT;
			}
			for(wCnt = 0; wCnt < KEY_REP_START; wCnt++){
				if(PUSH_SW3 == HIGH){
					return SW_SHORT;
				}
				delay_ms(10);
			}
			return SW_REPEAT;
		}
	}

	return SW_NONE;
}

////////////////////////////////////////////////////////////////////////////
BYTE get_sw4_rep(BYTE bRepFlg)
{
	//BYTE sw_state = SW_NONE;
	BYTE wCnt = 0;

	if(PUSH_SW4 == LOW){		//DOWN
		delay_ms(10);
		if(PUSH_SW4 == LOW){		//DOWN
			if(bRepFlg == SW_REPEAT){
				delay_ms(KEY_REP_TIME);
				return SW_REPEAT;
			}
			for(wCnt = 0; wCnt < KEY_REP_START; wCnt++){
				if(PUSH_SW4 == HIGH){
					return SW_SHORT;
				}
				delay_ms(10);
			}
			return SW_REPEAT;
		}
	}

	return SW_NONE;
}

////////////////////////////////////////////////////////////////////////////
void print_press_alt(BYTE val)
{
	i2c_lcd_putch('[');

	i2c_lcd_putch((val / 100) + '0');
	val %= 100;

	i2c_lcd_putch((val / 10) + '0');
	val %= 10;

	i2c_lcd_putch('.');

	i2c_lcd_putch(val + '0');

	i2c_lcd_putch(']');
}

////////////////////////////////////////////////////////////////////////////
// C.
//
// IN:
//
// OUT:
//
// RETURN:
//
////////////////////////////////////////////////////////////////////////////
main()
{
	BYTE i;
	BYTE bPressAltTmp = 0x00;
	BYTE bKeyRep3 = SW_NONE;
	BYTE bKeyRep4 = SW_NONE;
	signed long wAbsoluteAltTmp;

#ifdef _SERIAL_DEBUG_
	setup_oscillator(OSC_2MHZ);
#else //_SERIAL_DEBUG_
	setup_oscillator(OSC_2MHZ);
#endif //_SERIAL_DEBUG_

	set_tris_a(0b00111000);
	set_tris_c(0b00110000);

	setup_adc_ports(NO_ANALOGS);
	setup_adc(ADC_OFF);                  // disable A/D converter
	setup_comparator(NC_NC_NC_NC);       // disable comparator

	delay_ms(50);

	for(i = 0; i < MAX_SAMPLE; i++){
		dwSample[i] = 0;
	}

	i2c_lcd_init();
	//i2c_lcd_set_cgram();
	i2c_lcd_clear();

	for(i = 0;; i++){
		if(reg_read(0x0f) == 0xbb){
			break;
		}
		if(i >= 10){
			i2c_lcd_putch("Sens Err");
			while(1);
		}
		delay_ms(100);
	}

	bPressAlt = read_eeprom(ADDR_EEP_ALT);
	if((bPressAlt < PRESS_ALT_MIN) || (bPressAlt > PRESS_ALT_MAX)){
		bPressAlt = PRESS_ALT_DEF;
		write_eeprom(ADDR_EEP_ALT, bPressAlt);
	}

	while(1){
		PressOneShotStart();
		while(1){
			if(reg_read(0x21) == 0x00){
				read_press_data();
				calc_time();
				break;
			}
			delay_ms(10);
		}

		for(i = 0; i < 35; i++){
			delay_ms(10);
			if(get_sw1() == HIGH){	//MODE.
				if(bitPrintMode == 1){	//ڍו\.
					bitPrintMode = 0;
				}
				else{					//x\.
					bitPrintMode = 1;
				}
			}
			if(get_sw2() == SW_LONG){	//SET.
				if(bitPrintMode == 0){		//x\.
					if(bitSelector == 0){	//΍x.
						wRelativePress = (WORD)((float)GetSampleData() * 10.0);
						i2c_lcd_goto(0x02);
						i2c_lcd_putch("Set   ");
						delay_ms(1000);
					}
					else{					//΍x.
						wAbsoluteAltTmp = wAbsoluteAlt;
						if(wAbsoluteAltTmp < 0){
							wAbsoluteAltTmp = 0;
						}
						while(1){
							i2c_lcd_goto(0x42);
							printf(i2c_lcd_putch, "[%4ld]", wAbsoluteAltTmp);

							if(get_sw1() == HIGH){	//LZ.
								i2c_lcd_goto(0x42);
								i2c_lcd_putch("Cancel");
								delay_ms(1000);
								break;
							}
							if(get_sw2() != SW_NONE){	//ݒ.
								wAbsolutePress = (WORD)((float)GetSampleData() * 10.0);
								wAbsoluteAlt = wAbsoluteAltTmp;
								i2c_lcd_goto(0x42);
								i2c_lcd_putch("Set   ");
								delay_ms(1000);
								break;
							}
							if((bKeyRep3 = get_sw3_rep(bKeyRep3)) != SW_NONE){	//UP.
								if(wAbsoluteAltTmp < 9999){
									wAbsoluteAltTmp++;
								}
							}
							if((bKeyRep4 = get_sw4_rep(bKeyRep4)) != SW_NONE){	//DOWN.
								if(wAbsoluteAltTmp > 0){
									wAbsoluteAltTmp--;
								}
							}
						}
					}
				}
				else{	//ڍו\.
					i2c_lcd_clear();
					i2c_lcd_putch("CoeffSet");
					bPressAltTmp = bPressAlt;
					while(1){
						i2c_lcd_goto(0x41);

						print_press_alt(bPressAltTmp);

						if(get_sw1() == HIGH){	//LZ.
							i2c_lcd_goto(0x41);
							i2c_lcd_putch("Cancel");
							delay_ms(1000);
							break;
						}
						if(get_sw2() != SW_NONE){	//ݒ.
							write_eeprom(ADDR_EEP_ALT, bPressAltTmp);
							bPressAlt = bPressAltTmp;
							i2c_lcd_goto(0x41);
							i2c_lcd_putch("Set   ");
							delay_ms(1000);
							break;
						}
						if((bKeyRep3 = get_sw3_rep(bKeyRep3)) != SW_NONE){	//UP.
							if(bPressAltTmp < PRESS_ALT_MAX){
								bPressAltTmp++;
							}
						}
						if((bKeyRep4 = get_sw4_rep(bKeyRep4)) != SW_NONE){	//DOWN.
							if(bPressAltTmp > PRESS_ALT_MIN){
								bPressAltTmp--;
							}
						}
					}
				}
			}
			if(get_sw3() == HIGH){	//UP.
				if(bitPrintMode == 0){
					bitSelector = 0;
				}
			}
			if(get_sw4() == HIGH){	//DOWN.
				if(bitPrintMode == 0){
					bitSelector = 1;
				}
			}
		}
	}
}

