// I2CTestDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "I2CTest.h"
#include "I2CTestDlg.h"

#define _DLL_DYNAMIC_
//#undef _DLL_DYNAMIC_

#ifdef _DLL_DYNAMIC_
#include "i2c.h"
#else //_DLL_DYNAMIC_
#include "i2c_static.h"
#endif //_DLL_DYNAMIC_

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CI2CTestDlg _CAO

CI2CTestDlg::CI2CTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CI2CTestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CI2CTestDlg)
	m_iPort = -1;
	//}}AFX_DATA_INIT
	// : LoadIcon  Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CI2CTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CI2CTestDlg)
	DDX_CBIndex(pDX, IDC_COMPORT, m_iPort);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CI2CTestDlg, CDialog)
	//{{AFX_MSG_MAP(CI2CTestDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_SEARCH_DEVICE, OnSearchDevice)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CI2CTestDlg bZ[W nh

BOOL CI2CTestDlg::LibInitialize()
{
#ifdef _DLL_DYNAMIC_
	HINSTANCE hDll;

	if((hDll = LoadLibrary("i2c.dll")) == NULL){
		return FALSE;
	}
	else{
		if((i2c_start = (I2C_START)GetProcAddress(hDll,"i2c_start")) == NULL){
			FreeLibrary(hDll);
			return FALSE;
		}
		if((i2c_stop = (I2C_STOP)GetProcAddress(hDll,"i2c_stop")) == NULL){
			FreeLibrary(hDll);
			return FALSE;
		}
		if((i2c_write = (I2C_WRITE)GetProcAddress(hDll,"i2c_write")) == NULL){
			FreeLibrary(hDll);
			return FALSE;
		}
		if((i2c_read = (I2C_READ)GetProcAddress(hDll,"i2c_read")) == NULL){
			FreeLibrary(hDll);
			return FALSE;
		}
		if((i2c_connect = (I2C_CONNECT)GetProcAddress(hDll,"i2c_connect")) == NULL){
			FreeLibrary(hDll);
			return FALSE;
		}
		if((i2c_disconnect = (I2C_DISCONNECT)GetProcAddress(hDll,"i2c_disconnect")) == NULL){
			FreeLibrary(hDll);
			return FALSE;
		}
	}
#endif //_DLL_DYNAMIC_
	return TRUE;
}

void ResetListItem(void)
{
	CListCtrl *pList = (CListCtrl*)AfxGetMainWnd()->GetDlgItem(IDC_LIST);
	int i;
	char cStr[8];

	pList->DeleteAllItems();

	for(i = 0; i < 8; i++){
		wsprintf(cStr, "%02X", i << 4);
		pList->InsertItem(i, cStr);
	}
}

BOOL CI2CTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// ̃_CAOp̃ACRݒ肵܂Bt[[N̓AvP[ṼC
	// EBhE_CAOłȂ͎Iɐݒ肵܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	SetIcon(m_hIcon, FALSE);		// ACRݒ
	
	// TODO: ʂȏs͂̏ꏊɒǉĂB
	if(LibInitialize() == FALSE){
		AfxMessageBox("CũG[ł");
		OnOK();
	}

	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);

	pList->InsertColumn(0, "ADR", LVCFMT_CENTER, 40);
	pList->InsertColumn(1, "0", LVCFMT_CENTER, 30);
	pList->InsertColumn(2, "1", LVCFMT_CENTER, 30);
	pList->InsertColumn(3, "2", LVCFMT_CENTER, 30);
	pList->InsertColumn(4, "3", LVCFMT_CENTER, 30);
	pList->InsertColumn(5, "4", LVCFMT_CENTER, 30);
	pList->InsertColumn(6, "5", LVCFMT_CENTER, 30);
	pList->InsertColumn(7, "6", LVCFMT_CENTER, 30);
	pList->InsertColumn(8, "7", LVCFMT_CENTER, 30);
	pList->InsertColumn(9, "8", LVCFMT_CENTER, 30);
	pList->InsertColumn(10, "9", LVCFMT_CENTER, 30);
	pList->InsertColumn(11, "A", LVCFMT_CENTER, 30);
	pList->InsertColumn(12, "B", LVCFMT_CENTER, 30);
	pList->InsertColumn(13, "C", LVCFMT_CENTER, 30);
	pList->InsertColumn(14, "D", LVCFMT_CENTER, 30);
	pList->InsertColumn(15, "E", LVCFMT_CENTER, 30);
	pList->InsertColumn(16, "F", LVCFMT_CENTER, 30);

	ResetListItem();

	m_iPort = 0;
	UpdateData(FALSE);

	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

// _CAO{bNXɍŏ{^ǉȂ΁AACR`悷
// R[hȉɋLqKv܂BMFC AvP[V document/view
// fgĂ̂ŁȀ̓t[[Nɂ莩Iɏ܂B

void CI2CTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// NCAg̋`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// VXéA[U[ŏEBhEhbOĂԁA
// J[\\邽߂ɂĂяo܂B
HCURSOR CI2CTestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

DWORD WINAPI I2CAccessThread(LPVOID lpParam)
{
	BYTE i;
	BYTE bAddr;
	BYTE bRet;
	char cStr[8];
	CListCtrl *pList = (CListCtrl*)AfxGetMainWnd()->GetDlgItem(IDC_LIST);
	CButton *pButton = (CButton*)AfxGetMainWnd()->GetDlgItem(IDC_SEARCH_DEVICE);

	for(i = 0; i <= 0x7f; i++){
		bAddr = i;
		i2c_start();
		bRet = i2c_write(bAddr << 1 | IIC_WRITE);
		i2c_stop();

		if(bRet == IIC_ACK){
			wsprintf(cStr, "%02X", bAddr);
			pList->SetItemText((bAddr >> 4), (bAddr & 0x0f) + 1, cStr);
		}
		else{
			pList->SetItemText((bAddr >> 4), (bAddr & 0x0f) + 1, "--");
		}

		//Sleep(0);
	}

	i2c_disconnect();

	pButton->EnableWindow(TRUE);

	return 0L;
}

void CI2CTestDlg::OnSearchDevice() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CButton *pButton = (CButton*)AfxGetMainWnd()->GetDlgItem(IDC_SEARCH_DEVICE);

	UpdateData(TRUE);

	if(i2c_connect(m_iPort + 1) == IIC_FAILURE){
		AfxMessageBox("|[gJ܂");
		return;
	}

	ResetListItem();
	pButton->EnableWindow(FALSE);

	DWORD  ThreadID;
	HANDLE hThread;
	hThread = CreateThread(0, 0, (LPTHREAD_START_ROUTINE)I2CAccessThread,
		NULL, 0, &ThreadID);
}
