////////////////////////////////////////////////////////////////////////////
//
// SerialPort to I2C Test Library.
//
//   Copyright by rubidesu 2013
//
//   http://www.gatelink.co.jp/hw/
//
//   Version 1.00 2013.09.02
//           1.10 2013.09.18
//
////////////////////////////////////////////////////////////////////////////

#ifndef _I2C_H_
#define _I2C_H_

#include <windows.h>

#define IIC_WRITE	0x00
#define IIC_READ	0x01

#define IIC_ACK		0x00
#define IIC_NACK	0x01

#define IIC_FAILURE	0x00
#define IIC_SUCCESS	0x01

typedef void (CALLBACK* I2C_START)(void);
typedef void (CALLBACK* I2C_STOP)(void);
typedef BYTE (CALLBACK* I2C_WRITE)(BYTE);
typedef BYTE (CALLBACK* I2C_READ)(BYTE);
typedef BYTE (CALLBACK* I2C_CONNECT)(WORD);
typedef BYTE (CALLBACK* I2C_DISCONNECT)(void);

I2C_START i2c_start;
I2C_STOP i2c_stop;
I2C_WRITE i2c_write;
I2C_READ i2c_read;
I2C_CONNECT i2c_connect;
I2C_DISCONNECT i2c_disconnect;

#endif //_I2C_H_
