////////////////////////////////////////////////////////////////////////////
//
// SerialPort to I2C Test Library.
//
//   Copyright by rubidesu 2013
//
//   http://www.gatelink.co.jp/hw/
//
//   Version 1.00 2013.09.02
//           1.10 2013.09.18
//
////////////////////////////////////////////////////////////////////////////

#ifndef _I2C_STATIC_H_
#define _I2C_STATIC_H_

#include <windows.h>

#define IIC_WRITE	0x00
#define IIC_READ	0x01

#define IIC_ACK		0x00
#define IIC_NACK	0x01

#define IIC_FAILURE	0x00
#define IIC_SUCCESS	0x01

#pragma comment(lib, "i2c.lib")

__declspec(dllimport) void __stdcall i2c_start(void);
__declspec(dllimport) void __stdcall i2c_stop(void);
__declspec(dllimport) BYTE __stdcall i2c_write(BYTE);
__declspec(dllimport) BYTE __stdcall i2c_read(BYTE);
__declspec(dllimport) BYTE __stdcall i2c_connect(WORD);
__declspec(dllimport) BYTE __stdcall i2c_disconnect(void);

#endif //_I2C_STATIC_H_
